﻿using System;
using System.Web.UI;
using System.Net;
using System.IO;
using System.Xml;
using System.Text;
using System.Text.RegularExpressions;

public partial class YandexSearch : System.Web.UI.Page
{
    const int DOCS_ON_PAGE = 10; // кол-во отображаемых документов результатов поиска на одной странице
    int PageIndex // номер текущей страницы в переключателе страниц
    {
        get { return ViewState["PageIndex"] == null ? 0 : Convert.ToInt32(ViewState["PageIndex"]); }
        set { ViewState["PageIndex"] = value; }
    }

    protected void btnSeach_Click(object sender, EventArgs e) // обработчик нажатия кнопки
    {
        DoSearch(txtQuery.Text, txtSite.Text, this.PageIndex);
    }
    protected void lnkPrev_Click(object sender, EventArgs e) // обработчик нажатия гиперссылки "далее"
    {
        DoSearch(txtQuery.Text, txtSite.Text, --this.PageIndex);
    }
    protected void lnkNext_Click(object sender, EventArgs e) // обработчик нажатия гиперссылки "назад"
    {
        DoSearch(txtQuery.Text, txtSite.Text, ++this.PageIndex);
    }

    /// <summary>
    /// Функция поиска
    /// </summary>
    /// <param name="searchQuery">поисковый запрос</param>
    /// <param name="hostName">адрес сайта, по которому будет производиться поиск</param>
    /// <param name="pageIndex">номер запрашиваемой страницы результатов поиска</param>
    public void DoSearch(string searchQuery, string hostName, int pageIndex)
    {
        // -------- отправляем запрос на сервис xmlsearch.yandex.ru -------- 
        HttpWebRequest objRequest = (HttpWebRequest)WebRequest.Create("http://xmlsearch.yandex.ru/xmlsearch");
        objRequest.Method = "POST";
        objRequest.ContentType = "application/xml";
        using (Stream str = objRequest.GetRequestStream())
        {
            using (XmlWriter writer = XmlWriter.Create(objRequest.GetRequestStream())) // формируем запрос
            {
                writer.WriteStartDocument();
                writer.WriteStartElement("request");
                writer.WriteElementString("query", searchQuery + "<<(host=\"" + hostName + "\")");
                if (pageIndex > 0)
                    writer.WriteElementString("page", pageIndex.ToString());
                writer.WriteElementString("maxpassages", "5");
                writer.WriteRaw("<groupings><groupby attr=\"\" mode=\"flat\" groups-on-page=\"" + DOCS_ON_PAGE.ToString() + "\" docs-in-group=\"1\" /></groupings>");
                writer.WriteEndElement();
                writer.WriteEndDocument();
            }
        }

        // -------- получаем ответ с сервиса xmlsearch.yandex.ru -------- 
        HttpWebResponse myResponse = (HttpWebResponse)objRequest.GetResponse();
        StreamReader reader = new StreamReader(myResponse.GetResponseStream(), Encoding.UTF8);
        string allReq = reader.ReadToEnd();
        reader.Close();
        XmlDocument xDocument = new XmlDocument();
        xDocument.InnerXml = allReq;

        // -------- смотрим нет ли ошибок -------- 
        XmlNode errNode = xDocument.SelectSingleNode("yandexsearch/response/error");
        if (errNode != null)
        {
            if (errNode.Attributes["code"] != null && errNode.Attributes["code"].Value == "15")
                this.ltlResults.Text = "Искомая комбинация слов нигде не встречается";
            else
                this.ltlResults.Text = "Ошибка. Код: " + errNode.Attributes["code"].Value;
            return;
        }

        // -------- определяем сколько документов нашлось --------
        XmlNode foundNode = xDocument.SelectSingleNode("yandexsearch/response/found[@priority='all']");
        if (foundNode == null)
        {
            this.ltlResults.Text = "Не удаётся определить кол-во найденныйх документов";
            return;
        }
        int totalResults = Convert.ToInt32(foundNode.InnerXml); // кол-во найденных документов
        int totalPages = (int)Math.Ceiling((decimal)totalResults / DOCS_ON_PAGE); // кол-во страниц с результатами

        // -------- формируем результаты поиска -------- 
        StringBuilder sb = new StringBuilder();
        sb.AppendFormat("<span class=\"SearchResults\">Результаты поиска для \"{0}\"</span>", Server.HtmlEncode(searchQuery));
        int c = 0;
        sb.Append("<ul>");
        foreach (XmlNode node in xDocument.SelectNodes("yandexsearch/response/results/grouping/group/doc"))
        {
            sb.AppendFormat("<li style=\"margin:20px 0;\"><a class=\"Title\" href=\"{1}\" style=\"font-size:120%\">{0}</a>",
                node.SelectSingleNode("title") != null ? hlwordsHighlight(node.SelectSingleNode("title").InnerXml) : node.SelectSingleNode("url").InnerXml,
                node.SelectSingleNode("url").InnerXml
                );
            sb.Append("<ul>");
            XmlNode passagesNode = node.SelectSingleNode("passages");
            if (passagesNode != null)
                foreach (XmlNode passage in passagesNode.SelectNodes("passage"))
                    sb.AppendFormat("<li>{0}</li>", hlwordsHighlight(passage.InnerXml));
            sb.Append("</ul>");
            sb.AppendFormat("<span class=\"Url\" style=\"color:#060;\">{0}&nbsp;&nbsp;(&nbsp;{1}&nbsp;байт)</span></li>", node.SelectSingleNode("url").InnerXml, node.SelectSingleNode("size").InnerXml);
            c++;
        }
        sb.Append("</ul>");
        ltlResults.Text = sb.ToString();
        if (c < DOCS_ON_PAGE - 1)
        {
            totalResults = this.PageIndex * DOCS_ON_PAGE + c;
            totalPages = this.PageIndex;
        }

        // -------- Настраиваем переключатель страниц -------- 
        this.lnkPrev.Visible = (pageIndex > 0);
        this.lnkNext.Visible = (pageIndex < totalPages - 1);

        this.lblCurrentPosition.Text = string.Format("<span>Результаты поиска {0}-{1}</span>",
            (pageIndex * DOCS_ON_PAGE) + 1,
            Math.Min(((pageIndex + 1) * DOCS_ON_PAGE), totalResults)
            );
    }

    /// <summary>
    /// Функция подсетки найденных результатов
    /// </summary>
    /// <param name="text">Текст в котором обозначены найденные фрагменты поискового запроса</param>
    /// <returns>Выделяет найднные фрагменты тегами strong</returns>
    public static string hlwordsHighlight(string text)
    {
        text = Regex.Replace(text, "<hlword[^>]*>", "<strong>", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        text = Regex.Replace(text, "</hlword>", "</strong>", RegexOptions.IgnoreCase | RegexOptions.Compiled);
        return text;
    }
}
